# BrightPath Tutoring - Free Website Template

A friendly, academic website template designed for tutoring centers, learning academies, and educational services. Built with pure HTML5 and CSS3.

## Quick Start

1. Download and unzip the template files
2. Open `index.html` in your browser to preview
3. Edit the HTML files to add your business information
4. Upload to any web hosting provider

## Pages Included

- **Home** (`index.html`) - Hero section, services overview, why choose us, testimonials, CTA
- **About** (`about.html`) - Company story, values, approach, team profiles, facility details
- **Services** (`services.html`) - Detailed program descriptions, how it works, pricing tiers
- **Contact** (`contact.html`) - Contact form, business info, FAQ, service area

## Customization

### Colors

Edit the CSS variables in `styles.css` under `:root`:

```css
--primary: #2563EB;       /* Bright Blue */
--secondary: #F59E0B;     /* Warm Yellow */
--accent: #10B981;        /* Soft Green */
--background: #FFFBF5;    /* Warm Off-White */
```

### Fonts

The template uses Google Fonts:
- **Fredoka** for headings
- **Nunito** for body text

To change fonts, update the `@import` URL and the `--font-heading` / `--font-body` variables.

### Content

Replace placeholder text with your actual business information:
- Business name, address, phone, and email
- Service descriptions and pricing
- Team member names, credentials, and bios
- Testimonials from real clients
- FAQ answers specific to your business

### Images

Add your images to the `images/` directory and update the HTML to reference them. Replace gradient placeholder areas with actual photos.

### Contact Form

The contact form is static HTML. Connect it to your preferred form handler:
- [Formspree](https://formspree.io)
- [Netlify Forms](https://www.netlify.com/products/forms/)
- Your own backend

## Tech Stack

- Pure HTML5 and CSS3 (no JavaScript frameworks)
- CSS Custom Properties for easy theming
- CSS Grid and Flexbox layouts
- Responsive design (1024px, 768px, 480px breakpoints)
- Font Awesome 6.5 icons
- Google Fonts (Fredoka + Nunito)
- Mobile navigation with vanilla JavaScript
- Reduced motion media query support

## Browser Support

Works in all modern browsers: Chrome, Firefox, Safari, Edge.

## License

Free for personal and commercial use. Attribution appreciated but not required.

Design by [ZADIE](https://zadie.com)
