# VaultSpace Storage - Free Self-Storage Website Template

A clean, functional website template designed for self-storage facilities, storage unit businesses, and warehouse rental companies.

## Pages Included

- **Home** (`index.html`) - Hero section, unit sizes with pricing, security features, testimonials, CTA
- **About** (`about.html`) - Facility story, core values, team profiles, facility stats
- **Units & Pricing** (`services.html`) - Detailed unit breakdowns with use cases, facility features, storage tips
- **Contact** (`contact.html`) - Reservation form, facility info, office hours, FAQ

## Quick Start

1. Download and unzip the template files
2. Open `index.html` in your browser to preview
3. Edit the HTML files to replace placeholder content with your business information
4. Upload to your web hosting provider

## Customization

### Colors

All colors are defined as CSS custom properties in `styles.css`. Update these values to match your brand:

```css
:root {
  --primary: #DC2626;       /* Bold red - buttons, accents */
  --primary-dark: #B91C1C;  /* Hover states */
  --primary-light: #FEE2E2; /* Icon backgrounds */
  --secondary: #1F2937;     /* Dark charcoal - headers, hero */
  --accent: #F9FAFB;        /* Light gray backgrounds */
}
```

### Fonts

The template uses Google Fonts:
- **Chivo** for headings
- **Inter** for body text

To change fonts, update the Google Fonts `<link>` tag in each HTML file and the `--font-heading` / `--font-body` variables in `styles.css`.

### Content

Replace placeholder content throughout:
- Business name, address, phone number, and email
- Unit sizes and monthly pricing
- Team member names and bios
- Testimonials
- FAQ answers
- Footer links

### Images

Image placeholders use CSS gradients. Replace them with your own photos:
- Facility exterior and interior shots
- Team headshots
- Unit interior photos

## Technical Details

- Pure HTML5 and CSS3 (no JavaScript frameworks)
- Responsive design (mobile, tablet, desktop)
- CSS Grid and Flexbox layouts
- Font Awesome 6.5 icons
- Mobile hamburger menu with vanilla JavaScript
- Accessible navigation with ARIA attributes

## Browser Support

- Chrome (latest)
- Firefox (latest)
- Safari (latest)
- Edge (latest)

## License

Free for personal and commercial use. Attribution appreciated but not required.

Design by [ZADIE](https://zadie.com)
