# TrueCoat Painters - Website Template

A fresh, colorful website template designed for painting companies and contractors. Teal and warm coral on soft cream with rounded corners and modern typography project professionalism and creativity.

## Pages Included

- **Home** (`index.html`) - Hero with color swatches, services overview, why choose us, portfolio showcase, testimonials, CTA
- **About** (`about.html`) - Company story, values, team profiles, stats bar
- **Services** (`services.html`) - 6 service categories with pricing, 3-tier interior painting packages
- **Contact** (`contact.html`) - Estimate request form, contact info, hours, FAQ

## Quick Start

1. Replace placeholder content with your business information
2. Update colors in the `:root` CSS variables in `styles.css`
3. Add your own project photos to the portfolio section
4. Update phone numbers, addresses, and email throughout
5. Connect the contact form to your preferred form handler
6. Replace team photos with actual staff images

## Customization

### Colors
Edit CSS custom properties in `styles.css`:

```css
:root {
  --primary: #0D9488;      /* Teal */
  --secondary: #F97066;    /* Warm coral */
  --cream: #FFF7ED;        /* Soft cream background */
}
```

### Fonts
Template uses Google Fonts:
- **Headings**: Sora
- **Body**: Red Hat Display

## Features

- Fully responsive (mobile, tablet, desktop)
- Mobile hamburger menu
- CSS custom properties for easy theming
- Font Awesome 6.5.0 icons
- Rounded, friendly design language
- Color swatch decorative elements
- Portfolio/before-after section
- Per-room pricing packages
- Accessibility-friendly (reduced motion support, ARIA labels)

## Tech Stack

- Pure HTML5 and CSS3
- No JavaScript frameworks
- Google Fonts
- Font Awesome icons
- CSS Grid and Flexbox layouts

## License

Free for personal and commercial use. Attribution appreciated but not required.

---

Design by [ZADIE](https://zadie.com)
