# ClearView Eye Care - Free Website Template

A bright, modern website template designed for optometrists, eye care practices, and vision centers. Built with pure HTML5 and CSS3.

## Pages Included

- **Home** (`index.html`) - Hero, services overview, insurance section, why choose us, brand showcase, testimonials, CTA
- **About** (`about.html`) - Practice story, team profiles, technology, philosophy
- **Services** (`services.html`) - Detailed service pages with pricing for eye exams, contacts, eyeglasses, pediatric care, eye disease management, and emergency care
- **Contact** (`contact.html`) - Appointment request form, office info, insurance list, FAQs

## Quick Start

1. Download and unzip the template
2. Open `index.html` in your browser
3. Edit the HTML files to add your practice information
4. Replace placeholder content with your own text and images
5. Upload to your web host

## Customization

### Colors

All colors are defined as CSS custom properties in `styles.css`. Update these values to match your brand:

```css
:root {
  --primary: #0284C7;
  --secondary: #334155;
  --accent: #7C3AED;
  --light-bg: #F0F9FF;
  --dark: #0F172A;
}
```

### Fonts

The template uses Google Fonts:
- **Plus Jakarta Sans** for headings
- **Atkinson Hyperlegible** for body text (designed for maximum readability)

### Images

Replace the placeholder visuals with your own photos:
- Practice exterior and interior
- Team headshots
- Equipment photos

### Content

Update all placeholder text with your actual:
- Practice name and contact details
- Team member names and bios
- Services and pricing
- Insurance providers accepted
- Office hours and location

## Tech Stack

- Pure HTML5 and CSS3
- No JavaScript frameworks required
- Google Fonts for typography
- Font Awesome 6.5 for icons
- CSS Grid and Flexbox layouts
- Mobile-first responsive design

## Browser Support

Works in all modern browsers including Chrome, Firefox, Safari, and Edge.

## License

Free for personal and commercial use. Attribution appreciated but not required.

---

Design by [ZADIE](https://zadie.com)
