# Serenity Wellness Spa - Website Template

A tranquil, luxurious website template for massage therapy clinics, wellness spas, and bodywork practices.

## Quick Start

1. Download and unzip the template
2. Open `index.html` in your browser
3. Customize content with your business information
4. Upload to any web hosting service

## Pages Included

- **Home** (`index.html`) - Hero section, services overview, featured package, team preview, testimonials
- **About** (`about.html`) - Spa story, philosophy, team profiles, facility tour, products used
- **Services** (`services.html`) - Full service menu with pricing, packages, add-ons, memberships
- **Contact** (`contact.html`) - Booking form, hours, location, FAQ

## Customization Guide

### Colors

Edit CSS variables in `styles.css`:

```css
:root {
  --primary: #9CAF88;        /* Soft sage */
  --secondary: #D4A5A5;      /* Dusty rose */
  --accent: #C9A962;         /* Warm gold */
  --cream: #FDF8F3;          /* Light background */
  --plum: #4A3C4A;           /* Dark accents */
}
```

### Typography

The template uses Google Fonts:
- **Headings:** Cormorant Infant (elegant, serene)
- **Body:** Raleway (refined, readable)

### Images

Replace placeholder backgrounds with your photos:
- Hero image: `.hero-image-main`
- Team photos: `.team-image`
- Facility photos: `.facility-item`
- Service images: Update background gradients with `background-image: url('your-image.jpg')`

### Content to Update

1. Business name and tagline
2. Services menu and pricing
3. Team member names, roles, and bios
4. Contact information and hours
5. Social media links
6. FAQ answers

## Features

- Fully responsive design
- Mobile navigation menu
- Curved section dividers for organic feel
- Service category organization
- Package and membership pricing cards
- Gift certificate section
- Booking form with service selection
- Accessibility-friendly

## Browser Support

- Chrome, Firefox, Safari, Edge (latest versions)
- Mobile browsers on iOS and Android

## License

Free for personal and commercial use.

---

Design by [ZADIE](https://zadie.com)
