# Pressed & Pure - Juice Bar Website Template

A fresh, vibrant website template designed for juice bars, smoothie shops, and wellness beverage businesses.

## Pages

- **Home** (`index.html`) - Hero, services overview, popular menu items, why choose us, testimonials, CTA
- **About** (`about.html`) - Origin story, values, team members, stats
- **Menu** (`services.html`) - Full menu with categories, prices, and cleanse program tiers
- **Contact** (`contact.html`) - Contact form, business info, catering details, FAQ

## Design

- **Aesthetic**: Fresh, vibrant, health-forward
- **Fonts**: Comfortaa (headings) + Wix Madefor Display (body) via Google Fonts
- **Colors**: Vibrant green (#22C55E), tropical mango (#FB923C), clean white (#FAFFFE)
- **Icons**: Font Awesome 6.5.0

## Quick Start

1. Download and unzip the template files
2. Replace placeholder content with your business information
3. Update colors in the CSS variables section of `styles.css`
4. Replace placeholder images in the `images/` folder
5. Update contact information, hours, and location
6. Deploy to your hosting provider

## Customization

### Colors
All colors are defined as CSS custom properties in `styles.css`. Update the `:root` variables to match your brand:

```css
:root {
  --primary: #22C55E;
  --secondary: #FB923C;
  /* ... */
}
```

### Fonts
Fonts are loaded from Google Fonts. To change fonts, update the `<link>` tag in each HTML file and the font variables in `styles.css`.

### Content
- Replace all placeholder text with your actual business content
- Update menu items, prices, and descriptions
- Add your team photos to the `images/` folder
- Update the contact form action URL to your form handler

## Browser Support

- Chrome, Firefox, Safari, Edge (latest versions)
- Responsive design for mobile, tablet, and desktop

## License

Free for personal and commercial use. Attribution appreciated but not required.

Design by [ZADIE](https://zadie.com)
