# NexGen IT Solutions — Free Website Template

A dark, technical managed IT services website template. Near-black background with cyan and indigo accents, Space Mono headings, subtle glow effects. Built for MSPs, IT support companies, and technology consultants.

## License

Free to use for any personal or commercial project. Attribution appreciated but not required.

## Quick Start

1. Download and unzip
2. Open `index.html` in your browser to preview
3. Edit content directly in the HTML files
4. Replace placeholder gradient backgrounds with real office/team photos

## Pages

- `index.html` — Homepage with hero, services grid, stats, client types, testimonials
- `about.html` — Team profiles, certifications, philosophy
- `services.html` — Managed IT plans with pricing tiers and a-la-carte services
- `contact.html` — Free IT assessment form, FAQ, support info

## Customization

### Business Details
Search and replace throughout all HTML files:
- `NexGen IT Solutions` → Your company name
- `(555) 867-5309` → Your phone number
- `info@nexgenit.com` → Your email
- Your city/service area

### Colors
Edit CSS variables in `styles.css` under `:root`:
- `--primary` — Cyan (#06B6D4)
- `--secondary` — Indigo (#6366F1)
- `--accent` — Green (#10B981)
- `--bg` — Near black (#0D1117)

### Fonts
Loaded from Google Fonts:
- **Space Mono** — Headings
- **Inter** — Body text

### Pricing
Update the managed IT plan pricing in `services.html` to match your actual rates and service tiers.

### Certifications
Update the certifications and partner logos section in `about.html` with your actual credentials (CompTIA, Microsoft, Cisco, etc.).

### Photos
Replace placeholder gradient divs with `<img>` tags pointing to team headshots or office photos. Dark backgrounds with cool lighting work best with this template's aesthetic.

## Built With

- Pure HTML5 & CSS3
- Google Fonts
- Font Awesome 6.5.0 icons
- No JavaScript frameworks
