# Atelier Home Design - Interior Designer Website Template

A free, elegant interior design website template with an editorial, magazine-like aesthetic. Built with pure HTML and CSS.

## Pages

- **Home** (`index.html`) - Hero, featured projects, services, philosophy, testimonials, CTA
- **About** (`about.html`) - Studio story, philosophy, values, team, awards
- **Portfolio** (`services.html`) - Project gallery organized by category, design process
- **Contact** (`contact.html`) - Project inquiry form, studio info, FAQ

## Quick Start

1. Download and unzip the template
2. Open `index.html` in your browser
3. Edit the HTML files with your own content
4. Replace placeholder images in the `images/` folder
5. Upload to your web host

## Customization

### Colors

Edit the CSS variables in `styles.css`:

```css
:root {
  --primary: #2C2C2C;        /* Charcoal - main text & dark elements */
  --secondary: #A3B18A;      /* Muted sage - accents & icons */
  --white: #FAF8F5;           /* Warm off-white - backgrounds */
  --cream: #F0EDE8;           /* Cream - alternate sections */
}
```

### Fonts

The template uses Google Fonts:
- **Bodoni Moda** - Headings (elegant serif)
- **Tenor Sans** - Body text (clean sans-serif)

To change fonts, update the Google Fonts `<link>` tag in each HTML file and the `--font-heading` and `--font-body` variables in `styles.css`.

### Content

- Replace all placeholder text with your own business information
- Add your own images to the `images/` folder
- Update contact details, address, and phone number
- Modify service offerings and portfolio projects

### Images

Image placeholders are styled with background colors. Replace them with your own photos by adding `<img>` tags or updating the background images in CSS.

## Features

- Responsive design (mobile, tablet, desktop)
- Mobile hamburger menu
- CSS-only animations with reduced motion support
- Contact form with project type and budget dropdowns
- FAQ section
- SEO-friendly semantic HTML
- Font Awesome icons

## Browser Support

- Chrome, Firefox, Safari, Edge (latest versions)
- iOS Safari, Android Chrome

## License

Free for personal and commercial use. Attribution appreciated but not required.

Design by [ZADIE](https://zadie.com)
