# Summit Build Co. - General Contractor Website Template

A rugged, professional website template designed for general contractors and construction companies. Built with pure HTML5 and CSS3.

## Quick Start

1. Download and unzip the template files
2. Open `index.html` in your browser to preview
3. Edit the HTML files to add your own content
4. Replace placeholder images with your project photos
5. Upload to your web hosting provider

## Files Included

- `index.html` - Home page with hero, services overview, projects, stats, and testimonials
- `about.html` - Company story, team, values, and certifications
- `services.html` - Detailed service offerings with pricing and descriptions
- `contact.html` - Estimate request form, contact info, and FAQs
- `styles.css` - All styles with CSS custom properties for easy theming
- `README.md` - This file

## Customization

### Colors

Edit the CSS custom properties in `styles.css` under `:root`:

```css
:root {
  --primary: #C2410C;       /* Construction orange */
  --secondary: #374151;     /* Concrete gray */
  --accent: #1E40AF;        /* Steel blue */
  --light-bg: #F5F5F4;      /* Warm stone */
  --dark: #1C1917;           /* Near black */
}
```

### Typography

The template uses Google Fonts (Oswald and Barlow). To change fonts, update the `<link>` tags in each HTML file and the `--font-heading` / `--font-body` variables in `styles.css`.

### Content

- Replace all placeholder text with your business information
- Update phone numbers, addresses, and email addresses
- Swap service descriptions and pricing to match your offerings
- Add your own team member names and bios

### Images

Project cards and team photos use solid background colors as placeholders. Replace with your own images by adding `background-image` properties or `<img>` tags.

## Features

- Responsive design (mobile, tablet, desktop)
- Mobile hamburger menu
- CSS custom properties for easy theming
- Font Awesome icons
- No JavaScript frameworks required
- Fast loading, minimal dependencies

## Browser Support

- Chrome 80+
- Firefox 75+
- Safari 13+
- Edge 80+

## License

This template is free for personal and commercial use. Attribution to ZADIE is appreciated but not required. You may remove the "Design by ZADIE" link from the footer.

## Credits

- Fonts: [Oswald](https://fonts.google.com/specimen/Oswald) and [Barlow](https://fonts.google.com/specimen/Barlow) from Google Fonts
- Icons: [Font Awesome 6.5](https://fontawesome.com/)
- Template by [ZADIE](https://zadie.com)
