# Rolling Fire Kitchen - Food Truck Website Template

A bold, street-food-inspired website template designed for food trucks, mobile kitchens, and street food vendors. Built with pure HTML5 and CSS3.

## Pages Included

- **Home** (`index.html`) - Hero, menu highlights, about snippet, weekly schedule, photo grid, testimonials, CTA
- **About** (`about.html`) - Origin story, crew bios, truck details, philosophy
- **Menu** (`services.html`) - Full menu with prices, sides & drinks, catering packages
- **Contact** (`contact.html`) - Catering inquiry form, contact info, schedule, FAQ

## Quick Start

1. Download and unzip the template
2. Open `index.html` in your browser
3. Edit the HTML files to add your own content, photos, and details
4. Upload to your web host

## Customization

### Colors
All colors are defined as CSS custom properties in `styles.css`. Change the values in the `:root` selector:

```css
:root {
  --primary: #B91C1C;        /* Fire red */
  --secondary: #1C1917;      /* Charcoal */
  --accent: #EAB308;         /* Mustard yellow */
  --fire-orange: #EA580C;    /* Fire orange accent */
  --cream: #FFFBEB;          /* Warm cream background */
}
```

### Typography
The template uses Google Fonts:
- **Headings**: Passion One (bold, street vibe)
- **Body**: Nunito (friendly, readable)

### Images
Replace the gradient placeholders with your own photos:
- Food photography for the photo grid
- Team/crew photos
- Truck exterior shots

### Content
Update all placeholder text with your actual:
- Business name and tagline
- Menu items and prices
- Team member names and bios
- Contact information
- Weekly schedule/locations
- Social media links

## Features

- Fully responsive (mobile, tablet, desktop)
- Mobile hamburger menu
- CSS custom properties for easy theming
- Font Awesome 6.5.0 icons
- No JavaScript frameworks required
- Accessible navigation with ARIA labels

## License

Free for personal and commercial use. Attribution appreciated but not required.

## Credits

Design by [ZADIE](https://zadie.com)
