# Peak Performance Training - Website Template

A dynamic, high-energy website template for personal trainers and fitness studios. Features a dark theme with bold red and lime accents, motivational design, and professional conversion elements.

## Quick Start

1. Download and extract the template files
2. Open `index.html` in your browser to preview
3. Edit the HTML files to customize content
4. Update `styles.css` to adjust colors and styling

## Files Included

```
fitness-studio/
├── index.html      # Home page
├── about.html      # About page
├── services.html   # Services page
├── contact.html    # Contact page
├── styles.css      # All styles
└── README.md       # This file
```

## Customization

### Colors

Edit the CSS variables in `styles.css` to change the color scheme:

```css
:root {
  --primary: #DC2626;       /* Power red */
  --primary-dark: #B91C1C;
  --primary-light: #EF4444;
  --secondary: #18181B;     /* Charcoal black */
  --accent: #84CC16;        /* Electric lime */
  --white: #FAFAF9;         /* Off-white */
  --gray: #71717A;          /* Steel gray */
  --black: #0A0A0A;
}
```

### Typography

The template uses Google Fonts:
- **Headings:** Anton (bold, impactful)
- **Body:** Manrope (modern, clean)

To change fonts, update the Google Fonts import and font-family variables in `styles.css`.

### Content

Replace placeholder content in each HTML file:
- Business name and tagline
- Phone numbers and email addresses
- Training packages and pricing
- Trainer profiles and certifications
- Client testimonials and transformations
- Address and facility details

### Images

Replace the gradient placeholders with actual images:
- Add `<img>` tags where needed
- Use the existing placeholder divs as guides for dimensions

## Features

- **Responsive Design:** Works on desktop, tablet, and mobile
- **Mobile Menu:** Hamburger menu for small screens
- **Dark Theme:** Bold, motivational aesthetic
- **Pricing Tables:** Clear package comparison
- **Transformation Gallery:** Before/after showcase section
- **Trainer Profiles:** Team member cards with certifications
- **Assessment Form:** Lead capture with fitness goals
- **FAQ Section:** Common client questions

## Browser Support

- Chrome (latest)
- Firefox (latest)
- Safari (latest)
- Edge (latest)

## Deployment

Upload all files to your web hosting provider. No build process or server-side code required.

For custom domains, update any absolute URLs and add appropriate meta tags for SEO.

## License

This template is free to use for personal and commercial projects. Attribution appreciated but not required.

---

Design by [ZADIE](https://zadie.com)
