# Boundary Line Fencing - Fencing Company Website Template

A strong, outdoor-themed website template designed for fencing contractors and fence installation companies. Built with pure HTML5 and CSS3.

## Quick Start

1. Download and unzip the template files
2. Open `index.html` in your browser to preview
3. Edit the HTML files to add your own content
4. Replace placeholder images with your project photos
5. Upload to your web hosting provider

## Files Included

- `index.html` - Home page with hero, services overview, process, and testimonials
- `about.html` - Company story, team, values, stats, and certifications
- `services.html` - Detailed service offerings with pricing, gallery, and comparison cards
- `contact.html` - Estimate request form, contact info, FAQ, and service area
- `styles.css` - All styles with CSS custom properties for easy theming
- `README.md` - This file

## Customization

### Colors

Edit the CSS custom properties in `styles.css` under `:root`:

```css
:root {
  --primary: #78350F;       /* Earthy brown */
  --secondary: #166534;     /* Forest green */
  --accent: #D2B48C;        /* Warm tan */
  --background: #FAF9F6;    /* Off-white */
  --dark: #1C1210;          /* Dark brown */
}
```

### Typography

The template uses Google Fonts (Archivo Black and Barlow). To change fonts, update the `<link>` tags in each HTML file and the `--font-heading` / `--font-body` variables in `styles.css`.

### Content

- Replace company name, address, phone, and email throughout all HTML files
- Update service descriptions and pricing to match your offerings
- Replace team member names, roles, and descriptions
- Update testimonials with real customer reviews
- Adjust service area tags on the contact page

### Images

All image placeholders use CSS gradients. Replace them with real photos by adding `<img>` tags or updating the `background` properties.

## Features

- Fully responsive (1024px, 768px, 480px breakpoints)
- Mobile hamburger menu
- CSS-only animations with reduced motion support
- Contact form with service selection dropdown
- Pricing comparison cards
- Project gallery with hover labels
- FAQ section
- Service area coverage display
- 4-column footer layout

## License

Free for personal and commercial use. Attribution appreciated but not required.
