# Bright Spark Electric - Website Template

A professional website template for electricians and electrical contractors. Features a bold, high-contrast design with safety-inspired aesthetics, yellow and black color palette, and modern styling.

## Quick Start

1. Download and extract the template files
2. Open `index.html` in your browser to preview
3. Edit the HTML files to customize content
4. Update `styles.css` to adjust colors and styling

## Files Included

```
electrician/
├── index.html      # Home page
├── about.html      # About page
├── services.html   # Services page
├── contact.html    # Contact page
├── styles.css      # All styles
└── README.md       # This file
```

## Customization

### Colors

Edit the CSS variables in `styles.css` to change the color scheme:

```css
:root {
  --electric-yellow: #FFD700;
  --deep-blue: #1A365D;
  --safety-orange: #FF6B35;
  --carbon-black: #1C1C1C;
  --soft-white: #F8F9FA;
}
```

### Typography

The template uses Google Fonts:
- **Headings:** Rajdhani (bold, technical)
- **Body:** Karla (friendly, readable)

To change fonts, update the Google Fonts import and font-family variables in `styles.css`.

### Content

Replace placeholder content in each HTML file:
- Business name and tagline
- Phone numbers and email addresses
- Service descriptions and pricing
- Team member information
- Testimonials
- Address and service area

### Images

Replace the gradient placeholders with actual images:
- Add `<img>` tags where needed
- Use the existing placeholder divs as guides for dimensions

## Features

- **Responsive Design:** Works on desktop, tablet, and mobile
- **Mobile Menu:** Hamburger menu for small screens
- **Safety-Themed:** Yellow/black caution stripe accents
- **Emergency Focus:** Prominent 24/7 emergency contact display
- **Service Categories:** Organized service listings by type
- **Pricing Guide:** Transparent pricing section
- **FAQ Section:** Common customer questions
- **Contact Form:** Service request form with dropdown selections

## Browser Support

- Chrome (latest)
- Firefox (latest)
- Safari (latest)
- Edge (latest)

## Deployment

Upload all files to your web hosting provider. No build process or server-side code required.

For custom domains, update any absolute URLs and add appropriate meta tags for SEO.

## License

This template is free to use for personal and commercial projects. Attribution appreciated but not required.

---

Design by [ZADIE](https://zadie.com)
