# Harvest Table Catering - Free Website Template

A warm, elegant website template designed for catering companies, event caterers, and private chef services. Features a refined serif typography pairing and a rich burgundy-and-gold color palette.

## Quick Start

1. Download and unzip the template files
2. Open `index.html` in your browser to preview
3. Edit the HTML files to add your own content
4. Replace placeholder text with your business information
5. Upload to your web hosting provider

## Pages Included

- **Home** (`index.html`) - Hero section, services overview, why choose us, menu highlights, testimonials, and call-to-action
- **About** (`about.html`) - Company story, values, team members, and stats
- **Menus** (`services.html`) - Menu categories with sample dishes, catering packages with pricing, and custom menu note
- **Contact** (`contact.html`) - Event inquiry form, contact information, tasting appointments, and FAQ

## Customization

### Colors

Edit the CSS custom properties in `styles.css` to match your brand:

```css
:root {
  --burgundy: #7F1D1D;      /* Primary color */
  --gold: #B8860B;           /* Secondary/accent color */
  --linen: #FAF5EF;          /* Light background */
  --charcoal: #2C2420;       /* Dark text */
}
```

### Fonts

The template uses [Lora](https://fonts.google.com/specimen/Lora) for headings and [Crimson Pro](https://fonts.google.com/specimen/Crimson+Pro) for body text, loaded via Google Fonts. To change fonts, update the `@import` URL in `styles.css` and the `--font-heading` and `--font-body` variables.

### Content

- Replace all placeholder text with your actual business information
- Update phone numbers, email addresses, and physical address
- Replace menu items and pricing with your own offerings
- Update team member names, roles, and bios
- Replace testimonials with real client reviews

### Images

Place your images in the `images/` folder and update the HTML references. Recommended image sizes:
- Hero images: 1200x800px
- Team photos: 600x750px
- Menu/food photos: 800x600px

## Features

- Fully responsive design (mobile, tablet, desktop)
- Mobile hamburger menu
- CSS custom properties for easy theming
- Elegant serif typography
- Smooth hover animations
- Print stylesheet
- Reduced motion support for accessibility
- Semantic HTML5 structure

## Tech Stack

- Pure HTML5 & CSS3
- No JavaScript frameworks required
- Google Fonts (Lora + Crimson Pro)
- Font Awesome 6.5 icons

## License

This template is free for personal and commercial use. Attribution to ZADIE is appreciated but not required.

## Credits

Design by [ZADIE](https://zadie.com)
