# Sharp Edge Barbershop - Website Template

A vintage gentleman's barbershop website template with a classic, masculine aesthetic.

## Quick Start

1. Download and extract the template
2. Open `index.html` in your browser
3. Customize content, colors, and images to match your business

## Pages Included

- **Home** (`index.html`) - Hero, services overview, barber introductions, gallery, testimonials
- **About** (`about.html`) - Shop history, team profiles, values, facility, products
- **Services** (`services.html`) - Full service menu with pricing, combo packages
- **Contact** (`contact.html`) - Booking form, location, hours, FAQ

## Customization

### Colors

Edit the CSS custom properties in `styles.css`:

```css
:root {
  --primary: #0F172A;       /* Deep navy */
  --secondary: #7F1D1D;     /* Burgundy red */
  --accent: #D4AF37;        /* Gold */
  --cream: #FFFBEB;         /* Background cream */
  --wood: #78350F;          /* Rich brown */
}
```

### Fonts

This template uses Google Fonts:
- **Bebas Neue** - Headings
- **Barlow** - Body text

To change fonts, update the Google Fonts import and `--font-heading` / `--font-body` variables.

### Images

Replace placeholder areas with your own images:
- Barber photos (circular frames)
- Gallery images (square aspect ratio)
- Facility/shop photos

### Content

Update all placeholder text:
- Business name and tagline
- Service descriptions and pricing
- Team member bios
- Contact information
- Hours of operation

## Features

- Fully responsive design
- Mobile navigation menu
- CSS-only animations
- Accessible markup
- Print-friendly styling

## Browser Support

- Chrome (latest)
- Firefox (latest)
- Safari (latest)
- Edge (latest)

## License

This template is provided for use in personal and commercial projects. Attribution appreciated but not required.

---

Design by [ZADIE](https://zadie.com)
